<?php
require_once dirname(__FILE__) . '/../../TestUnitDB.php';

use Tygh\Languages\Values as LanguageValues;

/**
 * Tests \Tygh\Languages\Values
 */
class ValuesTest extends TestUnitDB
{

    protected function setUp()
    {
        parent::setUp();
    }

    protected function tearDown()
    {
    }

    public static function setUpBeforeClass()
    {
        \Tygh\Registry::set('runtime.company_id', 0);
    }

    protected function langVarsDataset()
    {
        return array(
            'language_values.xml',
        );
    }

    /**
     *
     * @datasetProvider langvarsDataset
     */
    public function testdeleteVariables()
    {
        $this->assertEquals(LanguageValues::deleteVariables('error'), 1);
    }

    /**
     *
     * @datasetProvider langVarsDataset
     */
    public function testGetVariables()
    {
        $res = array(
            'page' => 1,
            'items_per_page' => 5,
            'q' => 'error',
            'total_items' => 101,
        );

        list($langVars, $params) = LanguageValues::getVariables(array('q' => 'error'), 5);
        $this->assertEquals($params, $res);
    }

    public function testGetLangVar()
    {
        $this->assertEquals(LanguageValues::getLangVar('error'), 'Error');
    }

    public function testGetByName()
    {
        $res = array(array(
            'lang_code' => 'en',
            'name' => 'error',
            'value' => 'Error',
        ));

        $this->assertEquals(LanguageValues::getByName('error'), $res);
    }

    public function testGetByPrefix()
    {
        $this->assertNotEmpty(LanguageValues::getLangVarsByPrefix('error'));
    }

    public function testUpdateLangVar()
    {
        $params = array(
            'lang_code' => 'en',
            'name' => 'error',
            'value' => 'Error New',
        );

        $this->assertEquals(LanguageValues::updateLangVar(array($params)), array('error'));

        $langVar = LanguageValues::getByName('error');
        $this->assertEquals(array_shift($langVar), $params);
    }

    /**
     * Used to reset database.
     * Must be the last method in this class.
     *
     * @datasetProvider langVarsDataset
     */
    public function testEmpty()
    {
        $this->assertTrue(true);
    }
}
