<?php

use Tygh\Api;

define('DIR_ROOT', dirname(__FILE__) . '/../../../../');
define('AREA', 'A');

require dirname(__FILE__) . '/../../../../app/Tygh/Api.php';
require dirname(__FILE__) . '/../../../../app/Tygh/Api/FormatManager.php';

class ApiTest extends PHPUnit_Framework_TestCase
{
    protected $_object;

    protected function setUp()
    {
        parent::setUp();
        $this->_object = new Api();
    }

    protected function tearDown()
    {
    }

    /**
     *
     * @dataProvider divideDispatchProvider()
     */
    public function testGetEntityFromPathh($path, $expected)
    {
        $actual = $this->_object->getEntityFromPath($path);
        $this->assertEquals($expected, $actual);
    }

    public function divideDispatchProvider()
    {
        return array(
            array(
                "entity", array(
                    "name" => "entity",
                    "id" => "",
                ),
            ),
            array(
                "entity/", array(
                    "name" => "entity",
                    "id" => "",
                ),
            ),
            array(
                "entity/1", array(
                    "name" => "entity",
                    "id" => "1",
                ),
            ),
            array(
                "entity/sub_entity", array(
                    "name" => "entity",
                    "id" => "",
                    "child_entity" => array(
                        "name" => "sub_entity",
                        "id" => "",
                    )
                ),
            ),
            array(
                "entity//1//sub_entity", array(
                    "name" => "",
                    "id" => "",
                ),
            ),
            array(
                "entity////sub_entity", array(
                    "name" => "",
                    "id" => "",
                ),
            ),
            array(
                "entity/1/", array(
                    "name" => "entity",
                    "id" => "1",
                ),
            ),
            array(
                "entity/sub_entity/1", array(
                    "name" => "entity",
                    "id" => "",
                    "child_entity" => array(
                        "name" => "sub_entity",
                        "id" => "1",
                    )
                ),
            ),
            array(
                "entity/1123/sub_entity/999999", array(
                    "name" => "entity",
                    "id" => "1123",
                    "child_entity" => array(
                        "name" => "sub_entity",
                        "id" => "999999",
                    )
                ),
            ),
            array(
                "entity/1/sub_entity/12/sub_sub_entity", array(
                    "name" => "",
                    "id" => "",
                ),
            ),
        );
    }
}
