<?php
require dirname(__FILE__) . '/../../TestUnitDB.php';

use \Tygh\Registry;

/**
 * Tests API functionality via CURL
 */
class CurlWrapperApiTest extends TestUnitDB
{
    protected $_obejct;

    protected function setUp()
    {
        parent::setUp();
    }

    protected function tearDown()
    {
    }

    /**
     * Sample REST client
     *
     * @param  string $rest_path REST resource name
     * @param  string $method    HTTP Method
     * @param  mixed  $params    POST/PUT params
     * @param  array  $headers   Headers
     * @param  array  $auth      Auth params (username, apy key)
     * @return array  Response info, response body
     */
    protected function sendRequest($rest_path, $method, $params, $headers, $auth = array())
    {
        $curl = curl_init(Registry::get('config.http_location') . "/api.php" . "?" . http_build_query(array(\Tygh\Api::REST_RESOURCE_PARAM_NAME => $rest_path)));

        curl_setopt($curl, CURLOPT_HEADER, 0);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);

        if (!empty($auth)) {
            curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC ) ;
            curl_setopt($curl, CURLOPT_USERPWD, $auth[0] . ":" . $auth[1]);
        }

        if ($method == 'PUT') {
            $data = (is_array($params)) ? http_build_query($params) : $params;
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        } elseif ($method == 'POST') {
            $data = (is_array($params)) ? http_build_query($params) : $params;
            curl_setopt($curl, CURLOPT_POST, 1);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
        } else {
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $method);
        }

        curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($curl);
        $info = curl_getinfo($curl);

        curl_close($curl);

        return array($info, $result);
    }
}
