<?php
namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Api\Entities\Taxes;
use Tygh\Api\Response;
/**
 * Tests core API functionality via CURL
 */
class TaxesTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Taxes
     */
    protected $_obejct;

    protected function setUp()
    {
        parent::setUp();

        $this->_obejct = new Taxes(array(
            'area' => 'A',
            'user_id' => '1',
            'user_type' => 'A',
            'tax_exempt' => 'N',
            'last_login' => '1343637055',
            'usergroup_ids' => array ( ),
            'order_ids' => array ( ),
            'act_as_user' => false,
            'this_login' => 1343652763,
            'password_change_timestamp' => 0,
            'company_id' => 0,
            'is_root' => 'Y',
            'referer' => '',
            'ip' => '192.168.1.111',
            'first_expire_check' => false
        ));
    }

    protected function tearDown()
    {
    }

    protected function taxesDataset()
    {
        return array(
            'taxes.xml',
            'tax_descriptions.xml',
            'tax_rates.xml'
        );
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider taxesDataset
     */
    public function testIndex($id, $params, $result)
    {
        $this->assertEquals($result, $this->_obejct->index($id, $params));
    }

    public function providerIndex()
    {
        $params = array (
            'items_per_page' => '10',
            'page' => 1,
            'total_items' => 4
        );

        return array(
            // Get taxes list
            array('', array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'taxes' => array (
                        array(
                            'tax_id' => '6',
                            'address_type' => 'S',
                            'status' => 'A',
                            'price_includes_tax' => 'Y',
                            'display_including_tax' => 'N',
                            'display_info' => '',
                            'regnumber' => '1234242',
                            'priority' => '0',
                            'tax' => 'VAT',
                        ),
                        array(
                            'tax_id' => '7',
                            'address_type' => 'B',
                            'status' => 'A',
                            'price_includes_tax' => 'N',
                            'display_including_tax' => 'N',
                            'display_info' => '',
                            'regnumber' => 'abc',
                            'priority' => '0',
                            'tax' => 'VAT2',
                        ),
                        array(
                            'tax_id' => '8',
                            'address_type' => 'S',
                            'status' => 'A',
                            'price_includes_tax' => 'Y',
                            'display_including_tax' => 'N',
                            'display_info' => '',
                            'regnumber' => '321',
                            'priority' => '0',
                            'tax' => 'TAX',
                        ),
                        array(
                            'tax_id' => '9',
                            'address_type' => 'S',
                            'status' => 'D',
                            'price_includes_tax' => 'Y',
                            'display_including_tax' => 'Y',
                            'display_info' => '',
                            'regnumber' => '321',
                            'priority' => '1',
                            'tax' => 'XXX',
                        ),
                    ),
                    'params' => $params,
                ),
            )),
            // Get 1 tax
            array(
                6,
                array(),
                array(
                    'status' => Response::STATUS_OK,
                    'data' => array(
                        'tax_id' => '6',
                        'address_type' => 'S',
                        'status' => 'A',
                        'price_includes_tax' => 'Y',
                        'display_including_tax' => 'N',
                        'display_info' => '',
                        'regnumber' => '1234242',
                        'priority' => '0',
                        'tax' => 'VAT',
                    ),
                ),
            ),
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider taxesDataset
     */
    public function testCreate($params, $result)
    {
        $this->assertEquals($this->_obejct->create($params), $result);
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(array(), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'tax')),
                ),
            )),
            // Try create tax without tax name
            array(array(
                'regnumber' => '321',
                'priority' => 0,
                'status' => 'D',
            ), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'tax')),
                ),
            )),
            // Try create tax
            array(array(
                'tax' => 'test',
                'regnumber' => '321',
                'priority' => 0,
                'status' => 'D',
            ), array(
                'status' => Response::STATUS_CREATED,
                'data' => array(
                    'tax_id' => 10,
                ),
            )),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     * @datasetProvider taxesDataset
     */
    public function testUpdate($id, $params, $result)
    {
        $this->assertEquals($this->_obejct->update($id, $params), $result);
    }

    public function providerUpdate()
    {
        return array(
            // Try update
            array(6, array(
                'tax' => 'test',
                'regnumber' => '321',
                'priority' => 0,
                'status' => 'D',
            ), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'tax_id' => 6,
                ))
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     * @datasetProvider taxesDataset
     */
    public function testDelete($id, $result)
    {
        $actual = $this->_obejct->delete($id);
        $this->assertEquals($result, $actual);

        if ($actual['status'] == Response::STATUS_OK) {
            $actual = $this->_obejct->delete($id);
            $this->assertEquals(Response::STATUS_NOT_FOUND, $actual['status']);
        }
    }

    public function providerDelete()
    {
        return array(
            // Try delete with empty id
            array('', array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete with nonexistent id
            array(777, array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete
            array(9, array(
                'status' => Response::STATUS_NO_CONTENT,
                'data' => array(),
            )),
        );
    }
}
